/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.util.ticket;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import xesj.app.util.exception.BadTicketException;
import xesj.app.util.exception.HiddenException;
import xesj.app.util.main.Constant;
import xesj.app.util.main.SpBean;
import xesj.json.JsonNodeReader;
import xesj.tool.StringTool;

public class Ticket {
    private String id;
    private String name;
    private String size;
    private long sizeBytes;
    private int unit;

    public Ticket(String id) throws BadTicketException {
        int sizeValue;
        if (id == null) {
            throw new NullPointerException("Az 'id' param\u00e9ter nem lehet null!");
        }
        this.id = id;
        Matcher matcher = Constant.TICKET_PATTERN.matcher(id);
        if (!matcher.matches()) {
            throw new BadTicketException("A megh\u00edv\u00f3 form\u00e1tuma nem megfelel\u0151!");
        }
        if (!this.existDirectory()) {
            throw new BadTicketException("\u00c9rv\u00e9nytelen megh\u00edv\u00f3!");
        }
        if (!this.existOldDirectory()) {
            throw new HiddenException("Nem l\u00e9tezik 'old' alk\u00f6nyvt\u00e1r!");
        }
        if (!this.existJson()) {
            throw new HiddenException("Nem l\u00e9tezik 'ticket.json' f\u00e1jl!");
        }
        Path path = Paths.get(SpBean.property().getBaseDir(), id, "ticket.json");
        JsonNode jsonNode = (JsonNode)new ObjectMapper().readValue(path.toFile(), JsonNode.class);
        JsonNodeReader jsonNodeReader = new JsonNodeReader(jsonNode);
        String jsonId = jsonNodeReader.getString(new Object[]{"id"});
        String jsonName = jsonNodeReader.getString(new Object[]{"name"});
        String jsonSize = jsonNodeReader.getString(new Object[]{"size"});
        Integer jsonUnit = jsonNodeReader.getInteger(new Object[]{"unit"});
        if (jsonId == null || !jsonId.equals(id)) {
            throw new HiddenException("ticket.json (id) technikai hiba!");
        }
        if (StringTool.isNullOrEmpty((String)jsonName)) {
            throw new HiddenException("ticket.json (name) technikai hiba!");
        }
        this.name = jsonName;
        if (jsonUnit == null || jsonUnit < 1) {
            throw new HiddenException("ticket.json (unit) technikai hiba!");
        }
        this.unit = jsonUnit;
        String SIZE_ERROR_TEXT = "ticket.json (size) technikai hiba!";
        if (jsonSize == null || jsonSize.length() < 2) {
            throw new HiddenException("ticket.json (size) technikai hiba!");
        }
        char sizeKMG = jsonSize.charAt(jsonSize.length() - 1);
        if (sizeKMG != 'K' && sizeKMG != 'M' && sizeKMG != 'G') {
            throw new HiddenException("ticket.json (size) technikai hiba!");
        }
        try {
            sizeValue = Integer.parseInt(jsonSize.substring(0, jsonSize.length() - 1));
        }
        catch (NumberFormatException nfe) {
            throw new HiddenException("ticket.json (size) technikai hiba!");
        }
        if (sizeValue < 1) {
            throw new HiddenException("ticket.json (size) technikai hiba!");
        }
        this.size = jsonSize;
        this.sizeBytes = switch (sizeKMG) {
            case 'K' -> 1024L * (long)sizeValue;
            case 'M' -> 0x100000L * (long)sizeValue;
            case 'G' -> 0x40000000L * (long)sizeValue;
            default -> 0L;
        };
    }

    private boolean existDirectory() {
        Path path = Paths.get(SpBean.property().getBaseDir(), this.id);
        return path.toFile().exists();
    }

    private boolean existOldDirectory() {
        Path path = Paths.get(SpBean.property().getBaseDir(), this.id, "old");
        return path.toFile().exists();
    }

    private boolean existJson() {
        Path path = Paths.get(SpBean.property().getBaseDir(), this.id, "ticket.json");
        return path.toFile().exists();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ticket)) {
            return false;
        }
        Ticket ticket2 = (Ticket)object;
        return this.id.equals(ticket2.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSize() {
        return this.size;
    }

    public long getSizeBytes() {
        return this.sizeBytes;
    }

    public int getUnit() {
        return this.unit;
    }
}

