/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.util.password;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import xesj.app.util.exception.BadPasswordException;
import xesj.app.util.main.Constant;
import xesj.app.util.main.SpBean;
import xesj.app.util.password.Password;
import xesj.spring.html.Option;
import xesj.tool.ByteTool;

public class Password {
    private SecretKey secretKey;
    private SecretKey secretKeySalt0;

    public Password(String text, Type type) throws BadPasswordException {
        if (text == null) {
            throw new NullPointerException("A 'text' param\u00e9ter nem lehet null!");
        }
        if (type == null) {
            throw new NullPointerException("A 'type' param\u00e9ter nem lehet null!");
        }
        byte[] passwordBytes = null;
        if (type == Type.TEXT) {
            if (text.length() < 16) {
                throw new BadPasswordException("A sz\u00f6veges jelsz\u00f3nak legal\u00e1bb 16 karakternek kell lennie!");
            }
            passwordBytes = text.getBytes(StandardCharsets.UTF_8);
        }
        if (type == Type.HEXA) {
            if (text.length() < 32) {
                throw new BadPasswordException("A hexadecim\u00e1lis jelsz\u00f3nak legal\u00e1bb 32 karakteresnek kell lennie!");
            }
            try {
                passwordBytes = ByteTool.hexToByteArray((String)text);
            }
            catch (NumberFormatException nfe) {
                throw new BadPasswordException("Hexadecim\u00e1lis jelsz\u00f3 hiba. " + nfe.getMessage());
            }
        }
        this.secretKey = this.createSecretKey(passwordBytes, SpBean.application().getSaltHidden());
        this.secretKeySalt0 = this.createSecretKey(passwordBytes, Constant.SALT0);
    }

    private SecretKey createSecretKey(byte[] passwordBytes, byte[] salt) {
        byte[] byteArray = this.sha256(passwordBytes);
        for (int i = 0; i < salt.length; ++i) {
            byteArray[i * 13 % 32] = salt[i];
            byteArray = this.sha256(byteArray);
        }
        return new SecretKeySpec(byteArray, "AES");
    }

    private byte[] sha256(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    public static List<Option> getTypeOptions() {
        ArrayList<Option> passwordTypeOptions = new ArrayList<Option>();
        passwordTypeOptions.add(new Option(Type.TEXT.toString(), "sz\u00f6veges"));
        passwordTypeOptions.add(new Option(Type.HEXA.toString(), "hexadecim\u00e1lis"));
        return passwordTypeOptions;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public SecretKey getSecretKeySalt0() {
        return this.secretKeySalt0;
    }
}

