/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.util.note;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.springframework.stereotype.Service;
import xesj.app.util.main.Constant;
import xesj.app.util.note.NoteRow;
import xesj.tool.HtmlTool;

@Service
public class NoteUtil {
    public List<NoteRow> viewFormat(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<NoteRow> list = new ArrayList<NoteRow>();
        String[] rows = text.split("\n", -1);
        int minimumLevel = Integer.MAX_VALUE;
        for (String row : rows) {
            NoteRow noteRow = new NoteRow();
            if (row.startsWith("=====>")) {
                noteRow.text = row.substring(6);
                noteRow.level = 1;
            } else if (row.startsWith("----->")) {
                noteRow.text = row.substring(6);
                noteRow.level = 2;
            } else {
                noteRow.text = row;
                noteRow.level = 3;
            }
            noteRow.text = this.replaceLinks(noteRow.text);
            if (noteRow.level < minimumLevel) {
                minimumLevel = noteRow.level;
            }
            list.add(noteRow);
        }
        for (NoteRow noteRow : list) {
            int betolas;
            StringBuilder css = new StringBuilder();
            css.append("note-row fs-5 ");
            if (noteRow.level == 1) {
                css.append("bg-primary opacity-50 text-white px-2 my-2 ");
            }
            if (noteRow.level == 2) {
                css.append("bg-success opacity-50 text-white px-2 my-2 ");
            }
            if (noteRow.level == 3) {
                css.append("text-secondary ");
            }
            if ((betolas = noteRow.level - minimumLevel) == 1) {
                css.append("ms-4");
            }
            if (betolas == 2) {
                css.append("ms-5");
            }
            noteRow.css = css.toString();
        }
        return list;
    }

    private String replaceLinks(String str) {
        Matcher matcher = Constant.LINK_PATTERN.matcher(str);
        StringBuilder builder = new StringBuilder();
        int copy = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            builder.append(HtmlTool.escape((String)str.substring(copy, start)));
            builder.append(this.replaceOneLink(str.substring(start, end)));
            copy = end;
        }
        builder.append(HtmlTool.escape((String)str.substring(copy)));
        return builder.toString();
    }

    private String replaceOneLink(String str) {
        String url = HtmlTool.escape((String)str.substring(2, str.length() - 2).trim());
        Object href = url;
        String text = url;
        boolean targetBlank = true;
        if (url.startsWith("mailto:")) {
            href = "mailto:" + url.substring(7).trim();
            text = url.substring(7).trim();
            targetBlank = false;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<a").append(" href=\"").append((String)href).append("\"");
        if (targetBlank) {
            builder.append(" target=\"_blank\"");
        }
        builder.append(">").append(text).append("</a>");
        return builder.toString();
    }

    public String trim(String noteText) {
        if (noteText == null) {
            return null;
        }
        String[] array = noteText.split("\n", -1);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(array));
        for (int i = list.size() - 1; i >= 0 && list.get(i).trim().isEmpty(); --i) {
            list.remove(i);
        }
        while (!list.isEmpty() && list.get(0).trim().isEmpty()) {
            list.remove(0);
        }
        return list.isEmpty() ? null : String.join((CharSequence)"\n", list);
    }
}

