/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.util.main;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;
import xesj.spring.validation.FormValidationContext;
import xesj.spring.validation.MessageSourceLocale;
import xesj.spring.validation.ValidationContext;
import xesj.tool.LocaleTool;

@Service
public class MainUtil {
    @Autowired
    HttpServletRequest httpServletRequest;
    @Autowired
    @Lazy
    MessageSource messageSource;

    public String getIP() {
        String ip = this.httpServletRequest.getHeader("X-Forwarded-For");
        if (ip == null) {
            ip = this.httpServletRequest.getRemoteAddr();
        }
        return ip;
    }

    public FormValidationContext createFormValidationContext(BindingResult result, Integer fieldMessageMaximum, Integer globalMessageMaximum) {
        MessageSourceLocale msl = new MessageSourceLocale(this.messageSource, LocaleTool.LOCALE_HU);
        return new FormValidationContext(result, msl, fieldMessageMaximum, globalMessageMaximum);
    }

    public ValidationContext createValidationContext(Integer fieldMessageMaximum, Integer globalMessageMaximum, Integer throwCount) {
        MessageSourceLocale msl = new MessageSourceLocale(this.messageSource, LocaleTool.LOCALE_HU);
        return new ValidationContext(msl, fieldMessageMaximum, globalMessageMaximum, throwCount);
    }
}

