/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.util.main;

import java.util.Date;
import java.util.Map;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.webmvc.error.ErrorAttributes;
import org.springframework.web.context.request.WebRequest;

public class ErrorData {
    public Throwable throwable;
    public Date timestamp;
    public Integer status;
    public String error;
    public String message;
    public String path;
    public String trace;
    public Map<String, Object> attributesMap;

    public ErrorData(ErrorAttributes errorAttributes, WebRequest webRequest) {
        this.throwable = errorAttributes.getError(webRequest);
        ErrorAttributeOptions errorAttributeOptions = ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.MESSAGE, ErrorAttributeOptions.Include.STACK_TRACE});
        this.attributesMap = errorAttributes.getErrorAttributes(webRequest, errorAttributeOptions);
        this.timestamp = (Date)this.attributesMap.get("timestamp");
        this.status = (Integer)this.attributesMap.get("status");
        this.error = (String)this.attributesMap.get("error");
        this.message = (String)this.attributesMap.get("message");
        this.path = (String)this.attributesMap.get("path");
        this.trace = (String)this.attributesMap.get("trace");
    }

    public void print() {
        System.out.println("ErrorAttributes-map kulcsok, \u00e9s az \u00e9rt\u00e9k t\u00edpusa:");
        for (String key : this.attributesMap.keySet()) {
            Object value = this.attributesMap.get(key);
            String valueType = null;
            if (value != null) {
                valueType = value.getClass().getName();
            }
            System.out.println("  " + key + " -> " + valueType);
        }
    }
}

