/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.SecureRandom;
import java.text.Collator;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import xesj.app.system.MainSession;
import xesj.app.util.exception.BadFileNameException;
import xesj.app.util.exception.ConcurrentException;
import xesj.app.util.exception.DecodeException;
import xesj.app.util.exception.FileSizeException;
import xesj.app.util.exception.HiddenException;
import xesj.app.util.exception.UnitException;
import xesj.app.util.main.Constant;
import xesj.app.util.main.SpBean;
import xesj.app.util.password.Password;
import xesj.tool.ByteTool;
import xesj.tool.LocaleTool;
import xesj.tool.RandomTool;

/*
 * Exception performing whole class analysis ignored.
 */
public class HiddenFile {
    private String name;
    private boolean actual;
    private Password password;
    private Map<String, String> notes;
    private File renameFile;
    private File renameOldFile;

    public HiddenFile(String name, boolean actual) throws BadFileNameException {
        if (name == null) {
            throw new NullPointerException("A 'name' param\u00e9ter nem lehet null!");
        }
        String ERROR_MESSAGE = "A f\u00e1jln\u00e9v form\u00e1tuma helytelen: " + name;
        this.name = name;
        this.actual = actual;
        Matcher matcher = Constant.FILE_NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new BadFileNameException(ERROR_MESSAGE);
        }
        try {
            this.getLocalDateTime();
        }
        catch (DateTimeParseException dtpe) {
            throw new BadFileNameException(ERROR_MESSAGE);
        }
    }

    public HiddenFile(String baseName, String password, Password.Type passwordType) {
        this(HiddenFile.nameNow((String)baseName), true);
        if (baseName == null) {
            throw new NullPointerException("A 'baseName' param\u00e9ter nem lehet null!");
        }
        if (password == null) {
            throw new NullPointerException("A 'password' param\u00e9ter nem lehet null!");
        }
        if (passwordType == null) {
            throw new NullPointerException("A 'passwordType' param\u00e9ter nem lehet null!");
        }
        this.password = new Password(password, passwordType);
        this.notes = new HashMap();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HiddenFile)) {
            return false;
        }
        HiddenFile h = (HiddenFile)object;
        return h.getName().equals(this.name) && h.isActual() == this.actual;
    }

    public int hashCode() {
        return Objects.hashCode(this.name) + Objects.hashCode(this.actual);
    }

    public File getFile() {
        Path path = Paths.get(SpBean.property().getBaseDir(), SpBean.session().getTicket().getId(), this.actual ? "" : "old", this.name);
        return path.toFile();
    }

    public boolean isOpened() {
        MainSession session = SpBean.session();
        if (!session.hasOpenedFile()) {
            return false;
        }
        return this.equals((Object)session.getOpenedFile());
    }

    public int checkFile() throws FileNotFoundException, IOException {
        int version;
        File file;
        block9: {
            file = this.getFile();
            if (!file.exists()) {
                throw new HiddenException("A f\u00e1jl nem l\u00e9tezik: " + file.getCanonicalPath());
            }
            if (!file.canRead()) {
                throw new HiddenException("A f\u00e1jl nem olvashat\u00f3: " + file.getCanonicalPath());
            }
            try (FileInputStream fis = new FileInputStream(file);){
                byte[] bytes = new byte[7];
                int length = fis.read(bytes);
                if (length == 7 && bytes[0] == Constant.FILE_START[0] && bytes[1] == Constant.FILE_START[1] && bytes[2] == Constant.FILE_START[2] && bytes[3] == Constant.FILE_START[3] && bytes[4] == Constant.FILE_START[4] && bytes[5] == Constant.FILE_START[5]) {
                    version = ByteTool.byteToInt((Byte)bytes[6]);
                    break block9;
                }
                throw new HiddenException("A f\u00e1jl verzi\u00f3ja nem hat\u00e1rozhat\u00f3 meg: " + file.getCanonicalPath());
            }
        }
        if (!Constant.OPEN_FILE_VERSIONS.contains(version)) {
            throw new HiddenException("A f\u00e1jl verzi\u00f3ja: " + version + ". Ez a verzi\u00f3 nem t\u00e1mogatott! F\u00e1jl: " + file.getCanonicalPath());
        }
        return version;
    }

    public void open(Password password) throws DecodeException, Exception {
        byte[] decodedBytes;
        int version = this.checkFile();
        File file = this.getFile();
        byte[] ignoreBytes = new byte[7];
        byte[] gcmIvBytes = new byte[16];
        byte[] encodedBytes = new byte[(int)file.length() - ignoreBytes.length - gcmIvBytes.length];
        try (FileInputStream inputStream = new FileInputStream(file);){
            inputStream.read(ignoreBytes);
            inputStream.read(gcmIvBytes);
            inputStream.read(encodedBytes);
        }
        GCMParameterSpec gcmParameter = new GCMParameterSpec(128, gcmIvBytes);
        SecretKey secretKey = this.isSalt0() ? password.getSecretKeySalt0() : password.getSecretKey();
        Cipher cipher = Cipher.getInstance("AES_256/GCM/NoPadding");
        cipher.init(2, (Key)secretKey, gcmParameter);
        try {
            decodedBytes = cipher.doFinal(encodedBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new DecodeException("A jelsz\u00f3val a f\u00e1jl nem nyithat\u00f3 meg!");
        }
        if (decodedBytes.length < 16) {
            throw new DecodeException("A dek\u00f3dolt b\u00e1jt-sorozat hossza kevesebb mint 16 byte!");
        }
        for (int i = 0; i <= 7; ++i) {
            int b;
            int a = ByteTool.byteToInt((Byte)decodedBytes[i]);
            if (a + (b = ByteTool.byteToInt((Byte)decodedBytes[i + 8]).intValue()) == 255) continue;
            throw new DecodeException("A dek\u00f3dol\u00e1s sor\u00e1n hib\u00e1s ellen\u0151rz\u0151 b\u00e1jtok keletkeztek!");
        }
        this.notes = new HashMap();
        String s = new String(decodedBytes, 16, decodedBytes.length - 16, StandardCharsets.UTF_8);
        String[] array = s.split("\uffff", -1);
        for (int i = 0; i < array.length - 1; i += 2) {
            String noteName = array[i];
            String noteText = array[i + 1];
            if (noteText.isEmpty()) {
                noteText = null;
            }
            this.notes.put(noteName, noteText);
        }
        this.password = password;
    }

    public List<String> getNoteNames(String fragment) {
        String fragmentSearch = fragment == null ? null : fragment.trim().toLowerCase();
        return this.notes.keySet().stream().filter(s -> fragmentSearch == null || s.toLowerCase().contains(fragmentSearch)).sorted(Collator.getInstance(LocaleTool.LOCALE_HU)).collect(Collectors.toList());
    }

    public void save() throws UnitException, FileSizeException, Exception {
        int oldUnit;
        MainSession session = SpBean.session();
        int actualUnit = HiddenFile.getFiles((boolean)true, null).size();
        if (actualUnit + (oldUnit = HiddenFile.getFiles((boolean)false, null).size()) >= session.getTicket().getUnit()) {
            throw new UnitException(actualUnit, oldUnit);
        }
        StringBuilder builder = new StringBuilder();
        for (String key : this.notes.keySet()) {
            String text = Optional.ofNullable((String)this.notes.get(key)).orElse("");
            if (builder.length() > 0) {
                builder.append("\uffff");
            }
            builder.append(key).append("\uffff").append(text);
        }
        byte[] noteBytes = builder.toString().getBytes(StandardCharsets.UTF_8);
        byte[] authBytes = HiddenFile.getAuthBytes();
        byte[] decodedBytes = new byte[noteBytes.length + authBytes.length];
        System.arraycopy(authBytes, 0, decodedBytes, 0, authBytes.length);
        System.arraycopy(noteBytes, 0, decodedBytes, 16, noteBytes.length);
        byte[] gcmIvBytes = new byte[16];
        new SecureRandom().nextBytes(gcmIvBytes);
        GCMParameterSpec gcmParameter = new GCMParameterSpec(128, gcmIvBytes);
        SecretKey secretKey = this.isSalt0() ? this.password.getSecretKeySalt0() : this.password.getSecretKey();
        Cipher cipher = Cipher.getInstance("AES_256/GCM/NoPadding");
        cipher.init(1, (Key)secretKey, gcmParameter);
        byte[] encodedBytes = cipher.doFinal(decodedBytes);
        int fileSize = 23 + encodedBytes.length;
        if ((long)fileSize > session.getTicket().getSizeBytes()) {
            throw new FileSizeException((long)fileSize);
        }
        this.name = HiddenFile.nameNow((String)this.getBaseName());
        File file = this.getFile();
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(Constant.FILE_START);
            stream.write(ByteTool.intToByte((Integer)3).byteValue());
            stream.write(gcmIvBytes);
            stream.write(encodedBytes);
        }
        if (this.renameFile != null && this.renameOldFile != null) {
            this.renameFile.renameTo(this.renameOldFile);
            this.renameFile = null;
            this.renameOldFile = null;
        }
    }

    public void oldInfo() throws ConcurrentException {
        if (this.renameFile == null) {
            this.renameFile = this.getFile();
            Path path = Paths.get(SpBean.property().getBaseDir(), SpBean.session().getTicket().getId(), "old", this.name);
            this.renameOldFile = path.toFile();
        }
        if (!this.renameFile.exists()) {
            throw new ConcurrentException("A f\u00e1jl nem tal\u00e1lhat\u00f3 a f\u00e1jlrendszerben!");
        }
    }

    public boolean hasNote(String noteName) {
        if (noteName == null) {
            throw new NullPointerException("A 'noteName' param\u00e9ter nem lehet null!");
        }
        return this.notes.containsKey(noteName);
    }

    public void deleteFile() {
        this.getFile().delete();
    }

    public void property(String baseName, String password, Password.Type passwordType) {
        if (baseName != null) {
            this.name = HiddenFile.nameNow((String)baseName);
        }
        if (password != null) {
            this.password = new Password(password, passwordType);
        }
    }

    public String getBaseName() {
        return this.name.substring(0, this.name.length() - 27);
    }

    public boolean isSalt0() {
        return this.getBaseName().endsWith("-salt0");
    }

    public LocalDateTime getLocalDateTime() throws DateTimeParseException {
        String fragment = this.name.substring(this.name.length() - 26, this.name.length() - 7);
        return LocalDateTime.parse(fragment, Constant.DATE_FORMAT_HIDDEN_FILE_NAME.withResolverStyle(ResolverStyle.STRICT));
    }

    public String getFormattedDate() {
        return this.getLocalDateTime().format(Constant.DATE_FORMAT_YMD_HMS);
    }

    private static String nameNow(String baseName) {
        return baseName + "-" + LocalDateTime.now().format(Constant.DATE_FORMAT_HIDDEN_FILE_NAME) + ".hidden";
    }

    public static List<HiddenFile> getFiles(boolean actual, String fragment) {
        String fragmentSearch = fragment == null ? null : fragment.trim().toLowerCase();
        Path path = Paths.get(SpBean.property().getBaseDir(), SpBean.session().getTicket().getId(), actual ? "" : "old");
        try {
            return Files.list(path).map(p -> p.toFile().getName()).filter(n -> n.endsWith(".hidden")).map(n -> new HiddenFile(n, actual)).filter(h -> fragmentSearch == null || h.getBaseName().contains(fragmentSearch)).sorted((h1, h2) -> {
                int c = h1.getBaseName().compareTo(h2.getBaseName());
                return c != 0 ? c : h2.getLocalDateTime().compareTo(h1.getLocalDateTime());
            }).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static byte[] getAuthBytes() {
        byte[] authBytes = new byte[16];
        for (int i = 0; i <= 7; ++i) {
            int random = RandomTool.interval((int)0, (int)255);
            authBytes[i] = ByteTool.intToByte((Integer)random);
            authBytes[i + 8] = ByteTool.intToByte((Integer)(255 - random));
        }
        return authBytes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActual() {
        return this.actual;
    }

    public Password getPassword() {
        return this.password;
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public File getRenameFile() {
        return this.renameFile;
    }

    public File getRenameOldFile() {
        return this.renameOldFile;
    }
}

