/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.system;

import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.SessionScope;
import xesj.app.file.list.FileListForm;
import xesj.app.note.list.NoteListForm;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.password.Password;
import xesj.app.util.ticket.Ticket;

@Service
@SessionScope
public class MainSession {
    private Ticket ticket;
    private List<Password> passwords;
    private HiddenFile openedFile;
    FileListForm fileListForm;
    NoteListForm noteListForm;

    public boolean isTicketLogged() {
        return this.ticket != null;
    }

    public boolean isPasswordLogged() {
        return this.passwords != null;
    }

    public boolean isLogged() {
        return this.isTicketLogged() && this.isPasswordLogged();
    }

    public boolean hasOpenedFile() {
        return this.openedFile != null;
    }

    public boolean isOpenedActual() {
        return this.hasOpenedFile() && this.openedFile.isActual();
    }

    public boolean hasOpenedNote(String noteName) {
        if (noteName == null) {
            throw new NullPointerException("A 'noteName' param\u00e9ter nem lehet null!");
        }
        return this.hasOpenedFile() && this.openedFile.hasNote(noteName);
    }

    public void add(Password password, boolean loginPassword) {
        if (loginPassword) {
            this.passwords = new ArrayList();
            this.passwords.add(password);
        } else {
            while (this.passwords.size() >= 16) {
                this.passwords.remove(this.passwords.size() - 1);
            }
            this.passwords.add(0, password);
        }
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public List<Password> getPasswords() {
        return this.passwords;
    }

    public void setPasswords(List<Password> passwords) {
        this.passwords = passwords;
    }

    public HiddenFile getOpenedFile() {
        return this.openedFile;
    }

    public void setOpenedFile(HiddenFile openedFile) {
        this.openedFile = openedFile;
    }

    public FileListForm getFileListForm() {
        return this.fileListForm;
    }

    public void setFileListForm(FileListForm fileListForm) {
        this.fileListForm = fileListForm;
    }

    public NoteListForm getNoteListForm() {
        return this.noteListForm;
    }

    public void setNoteListForm(NoteListForm noteListForm) {
        this.noteListForm = noteListForm;
    }
}

