/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.system;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import xesj.app.system.MainApplication;
import xesj.app.system.Property;
import xesj.app.util.exception.BadSaltException;
import xesj.app.util.exception.HiddenException;
import xesj.tool.ByteTool;

@Service
public class MainEventListener {
    public static final Logger LOGGER = Logger.getLogger(MainEventListener.class.getName());
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    Property property;
    @Autowired
    MainApplication application;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) throws IOException {
        MainApplication.context = this.applicationContext;
        File baseDirFile = new File(this.property.getBaseDir());
        LOGGER.info("Working directory: " + System.getProperty("user.dir"));
        LOGGER.info("Base directory: " + baseDirFile.getCanonicalPath());
        LOGGER.info("Temporary directory: " + System.getProperty("java.io.tmpdir"));
        LOGGER.info("Maximum memory usage: " + Runtime.getRuntime().maxMemory());
        if (!baseDirFile.exists()) {
            throw new HiddenException("Nem l\u00e9tezik a base directory!");
        }
        if (!baseDirFile.canRead()) {
            throw new HiddenException("Nem olvashat\u00f3 a base directory!");
        }
        if (!baseDirFile.canWrite()) {
            throw new HiddenException("Nem \u00edrhat\u00f3 a base directory!");
        }
        this.application.setSaltHidden(this.saltToBytes(this.property.getSalt()));
    }

    public byte[] saltToBytes(String salt) throws BadSaltException {
        byte[] bytes;
        if (salt == null) {
            throw new NullPointerException("A 'salt' param\u00e9ter nem lehet null!");
        }
        if (salt.length() < 32 || salt.length() > 512) {
            throw new BadSaltException("A 'salt' csak 32 - 512 karakteres lehet!");
        }
        try {
            bytes = ByteTool.hexToByteArray((String)salt);
        }
        catch (NumberFormatException nfe) {
            throw new BadSaltException("Hib\u00e1s 'salt'! " + nfe.getMessage());
        }
        return bytes;
    }
}

