/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.system;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.webmvc.error.ErrorAttributes;
import org.springframework.boot.webmvc.error.ErrorController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.WebRequest;
import xesj.app.system.MainSession;
import xesj.app.util.exception.ConcurrentException;
import xesj.app.util.exception.FileSizeException;
import xesj.app.util.exception.UnitException;
import xesj.app.util.main.ErrorData;

@Controller
public class MainErrorController
implements ErrorController {
    public static final String PATH = "/error";
    private static final String VIEW_UNIT_EXCEPTION = "/exception/unit-exception.html";
    private static final String VIEW_FILE_SIZE_EXCEPTION = "/exception/file-size-exception.html";
    private static final String VIEW_CONCURRENT_EXCEPTION = "/exception/concurrent-exception.html";
    private static final String VIEW_UNEXPECTED_EXCEPTION = "/exception/unexpected-exception.html";
    @Autowired
    ErrorAttributes errorAttributes;
    @Autowired
    MainSession session;

    @RequestMapping(value={"/error"})
    public String errorHandler(WebRequest webRequest, Model model) {
        ErrorData errorData = new ErrorData(this.errorAttributes, webRequest);
        model.addAttribute("errorData", (Object)errorData);
        try {
            throw errorData.throwable;
        }
        catch (UnitException unitException) {
            return this.unitExceptionHandler(unitException, model);
        }
        catch (FileSizeException fileSizeException) {
            return this.fileSizeExceptionHandler(fileSizeException, model);
        }
        catch (ConcurrentException concurrentException) {
            return this.concurrentExceptionHandler(concurrentException, model);
        }
        catch (Throwable t) {
            model.addAttribute("pageTitle", (Object)"V\u00e1ratlan hiba");
            return VIEW_UNEXPECTED_EXCEPTION;
        }
    }

    private String unitExceptionHandler(UnitException unitException, Model model) {
        model.addAttribute("pageTitle", (Object)"Hiba");
        model.addAttribute("actualUnit", (Object)unitException.actualUnit);
        model.addAttribute("oldUnit", (Object)unitException.oldUnit);
        model.addAttribute("allUnit", (Object)(unitException.actualUnit + unitException.oldUnit));
        model.addAttribute("maximumUnit", this.session.getTicket() == null ? "?" : Integer.valueOf(this.session.getTicket().getUnit()));
        return VIEW_UNIT_EXCEPTION;
    }

    private String fileSizeExceptionHandler(FileSizeException fileSizeException, Model model) {
        model.addAttribute("pageTitle", (Object)"Hiba");
        model.addAttribute("fileSize", (Object)fileSizeException.fileSize);
        model.addAttribute("maxInText", (Object)(this.session.getTicket() == null ? "?" : this.session.getTicket().getSize()));
        model.addAttribute("maxInByte", this.session.getTicket() == null ? "?" : Long.valueOf(this.session.getTicket().getSizeBytes()));
        return VIEW_FILE_SIZE_EXCEPTION;
    }

    private String concurrentExceptionHandler(ConcurrentException concurrentException, Model model) {
        model.addAttribute("pageTitle", (Object)"Hiba");
        this.session.setOpenedFile(null);
        return VIEW_CONCURRENT_EXCEPTION;
    }
}

