/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.system;

import jakarta.servlet.http.HttpSession;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import xesj.app.system.MainApplication;
import xesj.app.system.MainSession;

@Controller
public class MainController {
    public static final String PATH_ROOT = "/";
    public static final String PATH_PING = "/ping";
    public static final String PATH_LOGOUT = "/logout";
    private static final String VIEW_LOGOUT = "/main/logout.html";
    @Autowired
    MainApplication application;
    @Autowired
    MainSession session;
    @Autowired
    HttpSession httpSession;

    @GetMapping(value={"/"})
    public String get(@RequestParam(required=false) String ticket, RedirectAttributes redirectAttributes) {
        if (ticket != null && this.session.isTicketLogged() && this.session.getTicket().getId().equals(ticket)) {
            return "redirect:/file/list";
        }
        redirectAttributes.addAttribute("ticket", (Object)ticket);
        return "redirect:/login/ticket";
    }

    @GetMapping(value={"/ping"})
    @ResponseBody
    public Map ping() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("data", null);
        map.put("error", null);
        return map;
    }

    @GetMapping(value={"/logout"})
    public String logout(Model model) {
        this.httpSession.invalidate();
        model.addAttribute("timeout", (Object)(this.application.getSessionTimeout(0) / 60));
        model.addAttribute("pageTitle", (Object)"Kil\u00e9p\u00e9s");
        return VIEW_LOGOUT;
    }
}

