/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.system;

import java.beans.PropertyEditor;
import java.time.LocalDate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.FixedLocaleResolver;
import org.springframework.web.servlet.mvc.WebContentInterceptor;
import xesj.app.system.LoginInterceptor;
import xesj.spring.property_editor.DatePropertyEditor;
import xesj.spring.property_editor.LocalDatePropertyEditor;
import xesj.spring.property_editor.StringPropertyEditor;
import xesj.tool.LocaleTool;

@Configuration
@ControllerAdvice
public class MainConfiguration
implements WebMvcConfigurer {
    @Autowired
    LoginInterceptor loginInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        WebContentInterceptor wci = new WebContentInterceptor();
        wci.addCacheMapping(CacheControl.noStore(), new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)wci).excludePathPatterns(new String[]{"/static/**"}).order(1);
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor).excludePathPatterns(new String[]{"/error", "/static/**", "/", "/ping", "/logout", "/login/ticket", "/login/password", "/test"}).order(2);
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) throws Exception {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringPropertyEditor());
        binder.registerCustomEditor(Date.class, (PropertyEditor)new DatePropertyEditor("yyyy.MM.dd"));
        binder.registerCustomEditor(LocalDate.class, (PropertyEditor)new LocalDatePropertyEditor("uuuu.MM.dd"));
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new FixedLocaleResolver(LocaleTool.LOCALE_HU);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/public/"}).setCacheControl(CacheControl.maxAge((long)1024L, (TimeUnit)TimeUnit.SECONDS).mustRevalidate().cachePublic());
    }
}

