/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.system;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;
import xesj.app.system.MainSession;
import xesj.app.system.Property;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.password.Password;
import xesj.app.util.ticket.Ticket;

@Service
public class LoginInterceptor
implements HandlerInterceptor {
    @Autowired
    MainSession session;
    @Autowired
    Property property;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        this.autoLoginOpen();
        if (!this.session.isTicketLogged()) {
            response.sendRedirect(request.getContextPath() + "/login/ticket");
            return false;
        }
        if (!this.session.isPasswordLogged()) {
            response.sendRedirect(request.getContextPath() + "/login/password");
            return false;
        }
        return true;
    }

    private void autoLoginOpen() throws Exception {
        if (this.property.getAutoLoginTicket() == null) {
            return;
        }
        if (!this.session.isTicketLogged() && !this.session.isPasswordLogged()) {
            Ticket ticket = new Ticket(this.property.getAutoLoginTicket());
            this.session.setTicket(ticket);
            this.session.setPasswords(new ArrayList());
        }
        if (this.property.getAutoOpenFile() == null || this.property.getAutoOpenActual() == null || this.property.getAutoOpenPassword() == null || this.property.getAutoOpenPasswordType() == null) {
            return;
        }
        if (!this.session.hasOpenedFile()) {
            HiddenFile hiddenFile = new HiddenFile(this.property.getAutoOpenFile(), this.property.getAutoOpenActual().booleanValue());
            Password password = new Password(this.property.getAutoOpenPassword(), this.property.getAutoOpenPasswordType());
            hiddenFile.open(password);
            this.session.add(password, true);
            this.session.setOpenedFile(hiddenFile);
        }
    }
}

