/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.note.view;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import xesj.app.system.MainSession;
import xesj.app.util.main.CheckUtil;
import xesj.app.util.note.NoteUtil;

@Controller
public class NoteViewController {
    public static final String PATH = "/note/view";
    private static final String VIEW = "/note/note-view.html";
    @Autowired
    MainSession session;
    @Autowired
    NoteUtil noteUtil;
    @Autowired
    CheckUtil checkUtil;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"Bejegyz\u00e9s megtekint\u00e9se");
    }

    @GetMapping(value={"/note/view"})
    public String get(@RequestParam String note, Model model) {
        this.check(note);
        String noteText = (String)this.session.getOpenedFile().getNotes().get(note);
        model.addAttribute("noteName", (Object)note);
        model.addAttribute("noteRows", (Object)this.noteUtil.viewFormat(noteText));
        return VIEW;
    }

    private void check(String note) {
        this.checkUtil.hasOpenedFile();
        this.checkUtil.hasOpenedNote(note);
    }
}

