/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.note.update;

import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import xesj.app.note.update.NoteUpdateForm;
import xesj.app.system.MainSession;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.main.CheckUtil;
import xesj.app.util.main.MainUtil;
import xesj.app.util.note.NoteUtil;
import xesj.spring.validation.FormValidationContext;
import xesj.spring.validation.validate.LengthValidate;
import xesj.spring.validation.validate.RequiredValidate;

@Controller
public class NoteUpdateController {
    public static final String PATH = "/note/update";
    private static final String VIEW = "/note/note-update.html";
    @Autowired
    MainSession session;
    @Autowired
    CheckUtil checkUtil;
    @Autowired
    MainUtil mainUtil;
    @Autowired
    NoteUtil noteUtil;

    @GetMapping(value={"/note/update"})
    public String get(@RequestParam(required=false) String note, Model model) {
        this.check(note);
        model.addAttribute("pageTitle", (Object)(note == null ? "\u00daj bejegyz\u00e9s" : "Bejegyz\u00e9s m\u00f3dos\u00edt\u00e1sa"));
        NoteUpdateForm form = new NoteUpdateForm();
        if (note != null) {
            form.setNoteNameOriginal(note);
            form.setNoteName(note);
            form.setNoteText((String)this.session.getOpenedFile().getNotes().get(note));
        }
        model.addAttribute("form", (Object)form);
        return VIEW;
    }

    @PostMapping(value={"/note/update"})
    public String get(@ModelAttribute(value="form") NoteUpdateForm form, BindingResult result, RedirectAttributes redirectAttributes, Model model) throws Exception {
        this.check(form.getNoteNameOriginal());
        this.validate(form, result);
        if (result.hasErrors()) {
            return VIEW;
        }
        HiddenFile hiddenFile = this.session.getOpenedFile();
        hiddenFile.oldInfo();
        Map notes = hiddenFile.getNotes();
        if (form.getNoteNameOriginal() != null) {
            notes.remove(form.getNoteNameOriginal());
        }
        notes.put(form.getNoteName(), form.getNoteText());
        hiddenFile.save();
        redirectAttributes.addAttribute("note", (Object)form.getNoteName());
        return "redirect:/note/view";
    }

    private void validate(NoteUpdateForm form, BindingResult result) {
        FormValidationContext context = this.mainUtil.createFormValidationContext(result, Integer.valueOf(1), null);
        if (form.getNoteName() != null) {
            form.setNoteName(form.getNoteName().trim());
        }
        form.setNoteText(this.noteUtil.trim(form.getNoteText()));
        String field = "noteName";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getNoteName()), () -> new LengthValidate(form.getNoteName(), Long.valueOf(1L), Long.valueOf(128L))});
        if (!result.hasFieldErrors(field)) {
            if (form.getNoteNameOriginal() == null) {
                if (this.session.hasOpenedNote(form.getNoteName())) {
                    context.add(field, "Ez a bejegyz\u00e9s n\u00e9v m\u00e1r l\u00e9tezik!");
                }
            } else if (!form.getNoteNameOriginal().equals(form.getNoteName()) && this.session.hasOpenedNote(form.getNoteName())) {
                context.add(field, "Ez a bejegyz\u00e9s n\u00e9v m\u00e1r l\u00e9tezik!");
            }
        }
        field = "noteText";
        context.add(field, new Supplier[]{() -> new LengthValidate(form.getNoteName(), Long.valueOf(0L), Long.valueOf(65536L))});
    }

    private void check(String note) {
        this.checkUtil.hasOpenedFile();
        this.checkUtil.isOpenedActual();
        if (note != null) {
            this.checkUtil.hasOpenedNote(note);
        }
    }
}

