/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.note.list;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import xesj.app.note.list.NoteListForm;
import xesj.app.system.MainSession;
import xesj.app.util.main.CheckUtil;
import xesj.tool.StringTool;

@Controller
public class NoteListController {
    public static final String PATH = "/note/list";
    private static final String VIEW = "/note/note-list.html";
    @Autowired
    MainSession session;
    @Autowired
    CheckUtil checkUtil;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"Bejegyz\u00e9sek");
        model.addAttribute("editable", (Object)this.session.isOpenedActual());
    }

    @GetMapping(value={"/note/list"})
    public String get(Model model) {
        this.check();
        NoteListForm form = Optional.ofNullable(this.session.getNoteListForm()).orElse(new NoteListForm());
        List notes = this.session.getOpenedFile().getNoteNames(form.getFragment());
        model.addAttribute("form", (Object)form);
        model.addAttribute("notes", (Object)notes);
        return VIEW;
    }

    @PostMapping(value={"/note/list"})
    public String post(@ModelAttribute(value="form") NoteListForm form, BindingResult result, Model model) {
        this.check();
        if (StringTool.equal((Object)form.getSubmit(), (Object)"TORLES")) {
            form.setFragment(null);
        }
        this.session.setNoteListForm(form);
        model.addAttribute("notes", (Object)this.session.getOpenedFile().getNoteNames(form.getFragment()));
        return VIEW;
    }

    private void check() {
        this.checkUtil.hasOpenedFile();
    }
}

