/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.note.delete;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import xesj.app.system.MainSession;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.main.CheckUtil;

@Controller
public class NoteDeleteController {
    public static final String PATH = "/note/delete";
    @Autowired
    MainSession session;
    @Autowired
    CheckUtil checkUtil;

    @GetMapping(value={"/note/delete"})
    public String get(@RequestParam String note, Model model) throws Exception {
        this.check(note);
        HiddenFile hiddenFile = this.session.getOpenedFile();
        hiddenFile.oldInfo();
        hiddenFile.getNotes().remove(note);
        hiddenFile.save();
        return "redirect:/note/list";
    }

    private void check(String note) {
        this.checkUtil.hasOpenedFile();
        this.checkUtil.isOpenedActual();
        this.checkUtil.hasOpenedNote(note);
    }
}

