/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.main;

import jakarta.servlet.http.HttpSession;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import xesj.app.main.LoginTicketForm;
import xesj.app.system.MainSession;
import xesj.app.util.main.MainUtil;
import xesj.app.util.ticket.Ticket;
import xesj.app.util.ticket.TicketValidate;
import xesj.spring.validation.FormValidationContext;
import xesj.spring.validation.ValidationContext;
import xesj.spring.validation.validate.LengthValidate;
import xesj.spring.validation.validate.RequiredValidate;

@Controller
public class LoginTicketController {
    public static final String PATH = "/login/ticket";
    private static final String VIEW = "/main/login-ticket.html";
    public static final Logger LOGGER = Logger.getLogger(LoginTicketController.class.getName());
    @Autowired
    MainSession session;
    @Autowired
    MainUtil mainUtil;
    @Autowired
    HttpSession httpSession;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"Bel\u00e9p\u00e9s, megh\u00edv\u00f3 megad\u00e1sa");
    }

    @GetMapping(value={"/login/ticket"})
    public String getLoginTicket(@RequestParam(required=false) String ticket, Model model) {
        this.httpSession.invalidate();
        LoginTicketForm form = new LoginTicketForm();
        if (ticket != null) {
            ValidationContext context = this.mainUtil.createValidationContext(Integer.valueOf(1), null, null);
            this.validate(ticket, context);
            if (!context.hasMessage()) {
                this.log(true, "GET", ticket);
                return this.goodTicket(ticket);
            }
            form.setTicketShadow(ticket);
            model.addAttribute("submit", (Object)true);
            this.log(false, "GET", ticket);
        }
        model.addAttribute("form", (Object)form);
        return VIEW;
    }

    @PostMapping(value={"/login/ticket"})
    public String postLoginTicket(@ModelAttribute(value="form") LoginTicketForm form, BindingResult result, Model model) {
        this.validate(form, result);
        if (result.hasErrors()) {
            this.log(false, "POST", form.getTicket());
            return VIEW;
        }
        this.log(true, "POST", form.getTicket());
        return this.goodTicket(form.getTicket());
    }

    private void validate(LoginTicketForm form, BindingResult result) {
        FormValidationContext context = this.mainUtil.createFormValidationContext(result, Integer.valueOf(1), null);
        String field = "ticket";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getTicket()), () -> new LengthValidate(form.getTicket(), Long.valueOf(39L), Long.valueOf(39L)), () -> new TicketValidate(form.getTicket())});
    }

    private void validate(String ticket, ValidationContext context) {
        String field = "ticket";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)ticket), () -> new LengthValidate(ticket, Long.valueOf(39L), Long.valueOf(39L)), () -> new TicketValidate(ticket)});
    }

    private String goodTicket(String id) {
        Ticket ticket = new Ticket(id);
        this.session.setTicket(ticket);
        return "redirect:/login/password";
    }

    private void log(boolean success, String method, String ticket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TICKET LOGIN ").append(success ? "SUCCESS" : "FAILED").append(", ip: ").append(this.mainUtil.getIP()).append(", method: ").append(method).append(", ticket: ").append(success ? ticket.substring(0, 5) : ticket).append(success ? "..." : "");
        LOGGER.info(stringBuilder.toString());
    }
}

