/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.main;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import xesj.app.main.LoginPasswordForm;
import xesj.app.system.MainSession;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.main.MainUtil;
import xesj.app.util.password.Password;
import xesj.app.util.password.PasswordValidate;
import xesj.spring.validation.FormValidationContext;
import xesj.spring.validation.validate.LengthValidate;
import xesj.spring.validation.validate.RequiredValidate;
import xesj.spring.validation.validate.SetValidate;

@Controller
public class LoginPasswordController {
    public static final String PATH = "/login/password";
    private static final String VIEW = "/main/login-password.html";
    @Autowired
    MainSession session;
    @Autowired
    MainUtil mainUtil;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"Bel\u00e9p\u00e9s, jelsz\u00f3 megad\u00e1sa");
        model.addAttribute("typeOptions", (Object)Password.getTypeOptions());
    }

    @GetMapping(value={"/login/password"})
    public String getLoginTicket(Model model) {
        if (!this.session.isTicketLogged()) {
            return "redirect:/login/ticket";
        }
        if (HiddenFile.getFiles((boolean)true, null).isEmpty() && HiddenFile.getFiles((boolean)false, null).isEmpty()) {
            ArrayList emptyList = new ArrayList();
            this.session.setPasswords(emptyList);
            return "redirect:/file/list";
        }
        LoginPasswordForm form = new LoginPasswordForm();
        form.setTipus(Password.Type.TEXT.name());
        model.addAttribute("form", (Object)form);
        return VIEW;
    }

    @PostMapping(value={"/login/password"})
    public String postLoginTicket(@ModelAttribute(value="form") LoginPasswordForm form, BindingResult result, Model model, RedirectAttributes redirectAttributes) throws UnsupportedEncodingException {
        if (!this.session.isTicketLogged()) {
            return "redirect:/login/ticket";
        }
        this.validate(form, result);
        if (result.hasErrors()) {
            return VIEW;
        }
        Password password = new Password(form.getJelszo(), Password.Type.valueOf((String)form.getTipus()));
        this.session.add(password, true);
        redirectAttributes.addAttribute("visible", (Object)false);
        return "redirect:/file/warning";
    }

    private void validate(LoginPasswordForm form, BindingResult result) {
        FormValidationContext context = this.mainUtil.createFormValidationContext(result, Integer.valueOf(1), null);
        String field = "tipus";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getTipus()), () -> new SetValidate((Object)form.getTipus(), new Object[]{Password.Type.TEXT.name(), Password.Type.HEXA.name()})});
        field = "jelszo";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getJelszo(), false), () -> new LengthValidate(form.getJelszo(), Long.valueOf(1L), Long.valueOf(64L))});
        if (!result.hasErrors()) {
            context.add(field, new Supplier[]{() -> new PasswordValidate(form.getJelszo(), Password.Type.valueOf((String)form.getTipus()), null, true)});
        }
    }
}

