/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.file.warning;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import xesj.app.file.warning.SizeDetail;
import xesj.app.system.MainSession;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.ticket.Ticket;

@Controller
public class FileWarningController {
    public static final String PATH = "/file/warning";
    private static final String VIEW = "/file/file-warning.html";
    @Autowired
    MainSession session;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"Figyelmeztet\u00e9sek");
    }

    @GetMapping(value={"/file/warning"})
    public String get(@RequestParam boolean visible, Model model) {
        model.addAttribute("warningLimit", (Object)80);
        Ticket ticket = this.session.getTicket();
        model.addAttribute("ticketSizeByte", (Object)ticket.getSizeBytes());
        model.addAttribute("ticketSizeText", (Object)ticket.getSize());
        model.addAttribute("ticketUnit", (Object)ticket.getUnit());
        List actualFiles = HiddenFile.getFiles((boolean)true, null);
        List oldFiles = HiddenFile.getFiles((boolean)false, null);
        model.addAttribute("unit", (Object)(actualFiles.size() + oldFiles.size()));
        model.addAttribute("unitActual", (Object)actualFiles.size());
        model.addAttribute("unitOld", (Object)oldFiles.size());
        boolean unitWarning = (double)(actualFiles.size() + oldFiles.size()) >= (double)(ticket.getUnit() * 80) / 100.0;
        model.addAttribute("unitWarning", (Object)unitWarning);
        ArrayList<SizeDetail> sizeFiles = new ArrayList<SizeDetail>();
        for (HiddenFile hiddenFile : actualFiles) {
            long hiddenSize = hiddenFile.getFile().length();
            if (!((double)hiddenSize >= (double)(ticket.getSizeBytes() * 80L) / 100.0)) continue;
            long percent = 100L * hiddenSize / ticket.getSizeBytes();
            SizeDetail sizeDetail = new SizeDetail(hiddenFile.getBaseName(), percent);
            sizeFiles.add(sizeDetail);
        }
        model.addAttribute("sizeFiles", sizeFiles);
        boolean sizeWarning = !sizeFiles.isEmpty();
        model.addAttribute("sizeWarning", (Object)sizeWarning);
        return visible || unitWarning || sizeWarning ? VIEW : "redirect:/file/list";
    }
}

