/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.file.open;

import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import xesj.app.file.open.FileOpenForm;
import xesj.app.system.MainSession;
import xesj.app.util.exception.DecodeException;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.main.MainUtil;
import xesj.app.util.password.Password;
import xesj.app.util.password.PasswordValidate;
import xesj.spring.validation.FormValidationContext;
import xesj.spring.validation.validate.LengthValidate;
import xesj.spring.validation.validate.RequiredValidate;
import xesj.spring.validation.validate.SetValidate;

@Controller
public class FileOpenController {
    public static final String PATH = "/file/open";
    private static final String VIEW = "/file/file-open.html";
    @Autowired
    MainSession session;
    @Autowired
    MainUtil mainUtil;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"F\u00e1jl megnyit\u00e1sa");
        model.addAttribute("typeOptions", (Object)Password.getTypeOptions());
    }

    @GetMapping(value={"/file/open"})
    public String get(@RequestParam String file, @RequestParam boolean actual, Model model) throws Exception {
        HiddenFile hiddenFile = new HiddenFile(file, actual);
        if (hiddenFile.isOpened()) {
            return "redirect:/note/list";
        }
        for (Password password : this.session.getPasswords()) {
            try {
                hiddenFile.open(password);
                this.session.setOpenedFile(hiddenFile);
                return "redirect:/note/list";
            }
            catch (DecodeException decodeException) {
            }
        }
        FileOpenForm form = new FileOpenForm();
        form.setFile(file);
        form.setActual(actual);
        form.setTipus(Password.Type.TEXT.name());
        model.addAttribute("form", (Object)form);
        model.addAttribute("hiddenFile", (Object)hiddenFile);
        return VIEW;
    }

    @PostMapping(value={"/file/open"})
    public String post(@ModelAttribute(value="form") FileOpenForm form, BindingResult result, Model model) throws Exception {
        this.validate(form, result);
        HiddenFile hiddenFile = new HiddenFile(form.getFile(), form.isActual());
        if (result.hasErrors()) {
            model.addAttribute("hiddenFile", (Object)hiddenFile);
            return VIEW;
        }
        Password password = new Password(form.getJelszo(), Password.Type.valueOf((String)form.getTipus()));
        this.session.add(password, false);
        hiddenFile.open(password);
        this.session.setOpenedFile(hiddenFile);
        return "redirect:/note/list";
    }

    private void validate(FileOpenForm form, BindingResult result) {
        FormValidationContext context = this.mainUtil.createFormValidationContext(result, Integer.valueOf(1), null);
        String field = "tipus";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getTipus()), () -> new SetValidate((Object)form.getTipus(), new Object[]{Password.Type.TEXT.name(), Password.Type.HEXA.name()})});
        field = "jelszo";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getJelszo(), false), () -> new LengthValidate(form.getJelszo(), Long.valueOf(1L), Long.valueOf(64L))});
        if (!result.hasErrors()) {
            context.add(field, new Supplier[]{() -> new PasswordValidate(form.getJelszo(), Password.Type.valueOf((String)form.getTipus()), form.getFile(), form.isActual())});
        }
    }
}

