/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.file.list;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import xesj.app.file.list.FileListForm;
import xesj.app.system.MainSession;
import xesj.app.util.file.HiddenFile;
import xesj.tool.StringTool;

@Controller
public class FileListController {
    public static final String PATH = "/file/list";
    private static final String VIEW = "/file/file-list.html";
    @Autowired
    MainSession session;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"F\u00e1jlok");
    }

    @GetMapping(value={"/file/list"})
    public String get(Model model) {
        FileListForm form = Optional.ofNullable(this.session.getFileListForm()).orElse(new FileListForm());
        model.addAttribute("form", (Object)form);
        this.getHiddenFiles(form, model);
        return VIEW;
    }

    @PostMapping(value={"/file/list"})
    public String post(@ModelAttribute(value="form") FileListForm form, BindingResult result, Model model) {
        if (StringTool.equal((Object)form.getSubmit(), (Object)"TORLES")) {
            form.setFragment(null);
            form.setOld(false);
        }
        this.session.setFileListForm(form);
        this.getHiddenFiles(form, model);
        return VIEW;
    }

    private void getHiddenFiles(FileListForm form, Model model) {
        model.addAttribute("actualFiles", (Object)HiddenFile.getFiles((boolean)true, (String)form.getFragment()));
        if (form.isOld()) {
            model.addAttribute("oldFiles", (Object)HiddenFile.getFiles((boolean)false, (String)form.getFragment()));
        }
    }
}

