/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.file.download;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import xesj.app.system.MainSession;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.main.Constant;
import xesj.tool.StreamTool;

@Controller
public class FileDownloadController {
    public static final String PATH = "/file/download";
    @Autowired
    MainSession session;

    @GetMapping(value={"/file/download"})
    public void get(HttpServletResponse response) throws FileNotFoundException, IOException {
        String zipName = "hidden-files-backup-ticket" + this.session.getTicket().getId().substring(0, 4) + "-" + LocalDateTime.now().format(Constant.DATE_FORMAT_HIDDEN_FILE_NAME) + ".zip";
        List hiddenFiles = HiddenFile.getFiles((boolean)true, null);
        hiddenFiles.addAll(HiddenFile.getFiles((boolean)false, null));
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=" + zipName);
        try (ServletOutputStream os = response.getOutputStream();
             ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
            ZipEntry entry = new ZipEntry("old/");
            zos.putNextEntry(entry);
            zos.closeEntry();
            for (HiddenFile hiddenFile : hiddenFiles) {
                entry = new ZipEntry((String)(hiddenFile.isActual() ? hiddenFile.getName() : "old/" + hiddenFile.getName()));
                zos.putNextEntry(entry);
                StreamTool.copy((InputStream)new FileInputStream(hiddenFile.getFile()), (OutputStream)zos, null);
                zos.closeEntry();
            }
        }
    }
}

