/*
 * Decompiled with CFR 0.152.
 */
package xesj.app.file.create;

import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import xesj.app.file.create.FileCreateForm;
import xesj.app.system.MainSession;
import xesj.app.util.file.HiddenFile;
import xesj.app.util.main.MainUtil;
import xesj.app.util.password.Password;
import xesj.app.util.password.PasswordSyntaxValidate;
import xesj.spring.validation.FormValidationContext;
import xesj.spring.validation.validate.CharacterContentValidate;
import xesj.spring.validation.validate.LengthValidate;
import xesj.spring.validation.validate.RequiredValidate;

@Controller
public class FileCreateController {
    public static final String PATH = "/file/create";
    private static final String VIEW = "/file/file-create.html";
    @Autowired
    MainSession session;
    @Autowired
    MainUtil mainUtil;

    @ModelAttribute
    public void configure(Model model) {
        model.addAttribute("pageTitle", (Object)"F\u00e1jl l\u00e9trehoz\u00e1sa");
        model.addAttribute("typeOptions", (Object)Password.getTypeOptions());
    }

    @GetMapping(value={"/file/create"})
    public String get(Model model) throws Exception {
        FileCreateForm form = new FileCreateForm();
        form.setJelszoTipus(Password.Type.TEXT.name());
        model.addAttribute("form", (Object)form);
        return VIEW;
    }

    @PostMapping(value={"/file/create"})
    public String post(@ModelAttribute(value="form") FileCreateForm form, BindingResult result, Model model) throws Exception {
        this.validate(form, result);
        if (result.hasErrors()) {
            return VIEW;
        }
        HiddenFile hiddenFile = new HiddenFile(form.getFajlnevKezdet(), form.getJelszo(), Password.Type.valueOf((String)form.getJelszoTipus()));
        hiddenFile.save();
        this.session.add(hiddenFile.getPassword(), false);
        this.session.setOpenedFile(hiddenFile);
        return "redirect:/note/list";
    }

    private void validate(FileCreateForm form, BindingResult result) {
        FormValidationContext context = this.mainUtil.createFormValidationContext(result, Integer.valueOf(1), null);
        String field = "fajlnevKezdet";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getFajlnevKezdet()), () -> new LengthValidate(form.getFajlnevKezdet(), Long.valueOf(1L), Long.valueOf(64L)), () -> new CharacterContentValidate(form.getFajlnevKezdet(), "abcdefghijklmnopqrstuvwxyz-0123456789")});
        if (context.enableAddMessage(field)) {
            List hiddenFiles = HiddenFile.getFiles((boolean)true, null);
            for (HiddenFile hiddenFile : hiddenFiles) {
                if (!form.getFajlnevKezdet().equals(hiddenFile.getBaseName())) continue;
                context.add(field, "Ilyen nev\u0171 f\u00e1jl m\u00e1r l\u00e9tezik!");
            }
        }
        field = "jelszoTipus";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getJelszoTipus())});
        field = "jelszo";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getJelszo()), () -> new LengthValidate(form.getJelszo(), Long.valueOf(1L), Long.valueOf(64L)), () -> new PasswordSyntaxValidate(form.getJelszo(), Password.Type.valueOf((String)form.getJelszoTipus()))});
        field = "jelszo2";
        context.add(field, new Supplier[]{() -> new RequiredValidate((Object)form.getJelszo2()), () -> new LengthValidate(form.getJelszo2(), Long.valueOf(1L), Long.valueOf(64L)), () -> new PasswordSyntaxValidate(form.getJelszo2(), Password.Type.valueOf((String)form.getJelszoTipus()))});
        if (!(result.hasFieldErrors("jelszo") || result.hasFieldErrors("jelszo2") || form.getJelszo().equals(form.getJelszo2()))) {
            context.add(null, "Nem egyezik a k\u00e9t jelsz\u00f3!");
        }
    }
}

